'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Button_Abbruch_Click()
On Error GoTo Err_Button_Abbruch_Click


    DoCmd.Close

Exit_Button_Abbruch_Click:
    Exit Sub

Err_Button_Abbruch_Click:
    MsgBox err.Description
    Resume Exit_Button_Abbruch_Click
    
End Sub

Private Sub Button_OK_Click()

    'Variablen deklarieren
    Dim dbs As Database
    Dim rst As Recordset
    Dim FilterText As String
    Dim KommaPosition As Long
    
    'Gltigkeitsprfungen
    If (IsNull(Me.Bezeichnung.Value) Or (Trim(Me.Bezeichnung.Value) = "")) Then
        MsgBox "Bitte geben Sie eine Bezeichnung ein!", vbCritical, "Fehler"
        Me.Bezeichnung.SetFocus
        Exit Sub
    End If
    
    On Error GoTo ErrorKategorievorgabeAnlegenFehler
    
    'Filterzeichenkette vorbereiten
    FilterText = "SELECT * FROM Kategorievorgaben WHERE [Kategorie] = '" & Trim(Left(Trim(Me.Bezeichnung.Value), 100)) & "'"
    
    'Tabelle ffnen und nachsehen, ob Prozentwert bereis vorhanden ist
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset(FilterText)
    If (rst.RecordCount) = 0 Then
    
        'Hinweis zum Warten anzeigen
        'DoCmd.OpenForm "Bitte_warten"
        'Forms![Bitte_warten].Repaint
    
        'Steuersatz anlegen
        rst.AddNew
        rst!Kategorie = Trim(Left(Trim(Me.Bezeichnung.Value), 100))
        rst!Kz = 0
        rst.Update
        rst.Close
    Else
        'wenn Prozentwert bereits vorhanden
        MsgBox "Diese Kategorievorgabe ist bereits vorhanden! Bitte geben Sie eine andere Bezeichnung ein.", vbCritical, "Fehler"
        Me.Bezeichnung.SetFocus
        Exit Sub
    End If
    
ExitKategorievorgabeAnlegen:
    Set rst = Nothing
    Set dbs = Nothing
    
    'Aufrufendes Formular zwecks Aktualisierung schlieen und wieder ffnen
    'DoCmd.Close acForm, FormularName, acSaveYes
    'DoCmd.OpenForm FormularName
    'Anzeige aktualisieren
    Forms![Einstellungen_6].[Kategorievorgaben].Form.Requery
    
    'sich selbst schlieen
    DoCmd.Close acForm, "Kategorievorgaben_neu", acSaveYes
    
    Exit Sub
    
    
ErrorKategorievorgabeAnlegenFehler:
        MsgBox "Beim Speichern der Kategorievorgabe trat ein Fehler auf!", vbCritical, "Fehler"
        MsgBox err.Description
        Resume ExitKategorievorgabeAnlegen

End Sub
